﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA orderable items contract.
    /// </summary>
    [Serializable]
    public class OrderableItem : IConcept
    {
        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the inactivated.
        /// </summary>
        /// <value>
        /// The inactivated.
        /// </value>
        
        public string Inactivated { get; set; }

        /// <summary>
        /// Gets or sets the name of the package.
        /// </summary>
        /// <value>
        /// The name of the package.
        /// </value>
        
        public string PackageName { get; set; }

        /// <summary>
        /// Gets or sets the display group id.
        /// </summary>
        /// <value>
        /// The display group id.
        /// </value>
        
        public string DisplayGroupId { get; set; }

        public override string ToString()
        {
            return "OrderableItems:" + Name;
        }
    }
}
